<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AlterMovimentosCaixaAddIndexes extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('movimentos_caixa', function (Blueprint $table) {
            $table->index(['conta_a_pagar_id', 'data_lancamento', 'tipo_movimento']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('movimentos_caixa', function (Blueprint $table) {
            $table->dropIndex(['conta_a_pagar_id', 'data_lancamento', 'tipo_movimento']);
        });
    }
}
