<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateRegistrosServidoresTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('registros_servidores', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('numero', 6);
            $table->date('data_admissao_prefeitura');
            $table->bigInteger('cargo_id');
            $table->foreign('cargo_id')
                    ->references('id')
                    ->on('cargos');
            $table->boolean('readaptado');
            $table->bigInteger('cargoreadaptado_id')->nullable();
            $table->foreign('cargoreadaptado_id')
                ->references('id')
                ->on('cargos');
            $table->bigInteger('unidadeorganizacional_id');
            $table->foreign('unidadeorganizacional_id')
                    ->references('id')
                    ->on('unidades_organizacionais');
            $table->bigInteger('servidor_id');
            $table->foreign('servidor_id')
                ->references('id')
                ->on('servidores');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('registros_servidores');
    }
}
