<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUnidadesOrganizacionaisTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('unidades_organizacionais', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('nome', 100);
            $table->string('sigla', 15)->nullable();
            $table->string('centro_custo', 11)->nullable();
            $table->string('observacoes', 100)->nullable();
            $table->bigInteger('superior_id')->nullable();
            $table->foreign('superior_id')
                    ->references('id')
                    ->on('unidades_organizacionais');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('unidades_organizacionais');
    }
}
