<?php

use App\Enums\SexoEnum;
use App\Models\Dependente;
use App\Enums\GrauParentescoEnum;
use App\Models\Servidor;
use Carbon\Carbon;
use Faker\Generator as Faker;

/*
|--------------------------------------------------------------------------
| Model Factories
|--------------------------------------------------------------------------
|
| This directory should contain each of the model factory definitions for
| your application. Factories provide a convenient way to generate new
| model instances for testing / seeding your application's database.
|
*/
$factory->define(Dependente::class, function (Faker $faker) {
    return [
        'nome' => $faker->name,
        'grau_parentesco' => GrauParentescoEnum::filho(),
        'dependivel_id' => factory(Servidor::class),
        'dependivel_type' => Servidor::class,
        'data_admissao' => Carbon::today()->format('d/m/Y'),
        'data_nascimento' => Carbon::today()->subYear(15)->format('d/m/Y'),
        'sexo' => SexoEnum::masculino()
    ];
});
