<?php

namespace App\Traits;

use App\Enums\TipoContatoEnum;
use App\Models\Contato;

trait Contatavel
{
    public function contatos()
    {
        return $this->morphMany(Contato::class, 'contatavel');
    }

    public function celularMalaDireta()
    {
        return $this->contatos()->celularMalaDireta()->first();
    }

    public function saveTelefones(array $telefones)
    {
        $telefonesCadastrados = $this->contatos()->telefones();
        $telefonesCadastrados->delete();

        foreach ($telefones as $telefone) {
            if (!$telefone['numero']) {
                continue;
            }
            $contato = new Contato();
            $contato->valor = $telefone['numero'];
            $contato->observacoes = $telefone['observacoes'];

            if (key_exists('mala_direta', $telefone)) {
                $contato->aceita_mala_direta = true;
            }

            $contato->tipo = TipoContatoEnum::telefoneFixo()->getIndex();

            if (strlen($telefone['numero']) == 15) {
                $contato->tipo = TipoContatoEnum::telefoneCelular()->getIndex();
            }

            $this->contatos()->save($contato);
        }
    }

    public function saveEmails(array $emails)
    {
        $emailsCadastrados = $this->contatos()->emails();
        $emailsCadastrados->delete();

        foreach ($emails as $email) {
            if (!$email['endereco']) {
                continue;
            }

            $contato = new Contato();
            $contato->valor = $email['endereco'];
            $contato->tipo = TipoContatoEnum::email()->getIndex();

            if (key_exists('mala_direta', $email)) {
                $contato->aceita_mala_direta = true;
            }

            $this->contatos()->save($contato);
        }
    }
}
