<?php

namespace App\Traits;

use App\Models\AgendamentoAtendimento;
use App\Models\Anamnese;
use App\Models\AtendimentoJuridico;
use App\Models\AtendimentoOdontologico;
use App\Models\ProcessoJuridico;

trait Atendivel
{
    public function agendamentos()
    {
        return $this->morphMany(AgendamentoAtendimento::class, 'agendavel');
    }

    public function anamnese()
    {
        return $this->morphOne(Anamnese::class, 'agendavel')->withDefault();
    }

    public function atendimentosOdontologicos()
    {
        return AtendimentoOdontologico::whereHas('agendamento', function ($query) {
            return $query->whereHasMorph('agendavel', self::class, function ($query) {
                return $query->where('id', $this->id);
            });
        });
    }

    public function atendimentosJuridicos()
    {
        return AtendimentoJuridico::whereHas('agendamento', function ($query) {
            return $query->whereHasMorph('agendavel', self::class, function ($query) {
                return $query->where('id', $this->id);
            });
        });
    }
}
