<?php

namespace App\Services;

use App\Events\ServidorReligadoExtraordinariamente;
use App\Exceptions\ValidationException;
use App\Models\Servidor;
use Carbon\Carbon;

class ReligaExtraordinariamenteService
{
    protected $servidor;
    protected $motivo;
    protected $data;

    public function __construct(Servidor $servidor, string $motivo, Carbon $data)
    {
        $this->servidor = $servidor;
        $this->motivo = $motivo;
        $this->data = $data;
    }

    public function religa()
    {
        $this->valida();

        $matricula = $this->servidor->matriculas()->desligadaDefinitivamente()->latest()->first();
        $matricula->motivo_religamento_extraordinario = $this->motivo;
        $matricula->data_religamento_extraordinario = $this->data;
        $matricula->data_desligamento = null;
        $matricula->motivo_desligamento = null;
        $matricula->tipo_desligamento = null;
        $matricula->religamento_extraordinario = true;
        $matricula->save();

        event(new ServidorReligadoExtraordinariamente($this->servidor, $matricula));

        return $matricula;
    }

    private function valida()
    {
        if (!$this->servidor->desfiliadoDefinitivamente()) {
            throw new ValidationException('Servidor não está desfiliado definitivamente');
        }
    }
}
