<?php

namespace App\Services;

use App\Models\Endereco;
use App\Models\UnidadeOrganizacional;
use Illuminate\Support\Facades\DB;

class IncluiUnidadeOrganizacionalService
{
    private $nome;
    private $sigla;
    private $unidadeSuperior;
    private $centroCusto;
    private $telefones;
    private $endereco;

    public function __construct(string $nome, string $sigla, $centroCusto = '', array $telefones = [], UnidadeOrganizacional $unidadeSuperior = null, Endereco $endereco = null)
    {
        $this->nome = $nome;
        $this->sigla = $sigla;
        $this->unidadeSuperior = $unidadeSuperior;
        $this->centroCusto = $centroCusto;
        $this->telefones = $telefones;
        $this->endereco = $endereco;
    }

    public function inclui()
    {
        $unidade = new UnidadeOrganizacional();
        $unidade->nome = $this->nome;
        $unidade->sigla = $this->sigla;
        $unidade->centro_custo = $this->centroCusto;
        $unidade->superior()->associate($this->unidadeSuperior);

        DB::beginTransaction();

        $unidade->save();
        $unidade->saveTelefones($this->telefones);

        if ($unidade->isSuperior()) {
            $unidade->hierarquia = "$unidade->id";
            $unidade->nivel = 1;
        } else {
            $unidade->hierarquia = "{$unidade->superior->hierarquia}/{$unidade->id}";
            $unidade->nivel = $unidade->superior->nivel + 1;
        }

        if ($this->endereco) {
            $unidade->enderecos()->save($this->endereco);
        }

        $unidade->save();

        DB::commit();

        return $unidade;
    }
}
