<?php

namespace App\Services;

use App\Events\ServidorAfiliado;
use App\Exceptions\ValidationException;
use App\Models\Matricula;
use App\Models\MotivoFiliacao;
use App\Models\Servidor;
use Carbon\Carbon;

class AfiliaSindicatoService
{
    protected $servidor;
    protected $motivo;
    protected $motivoOutros;
    protected $data;

    public function __construct(Servidor $servidor, MotivoFiliacao $motivo, Carbon $data, string $motivoOutros = null)
    {
        $this->servidor = $servidor;
        $this->motivo = $motivo;
        $this->motivoOutros = $motivoOutros;
        $this->data = $data;
    }

    public function afilia()
    {
        $this->valida();

        $matricula = new Matricula();
        $matricula->motivoFiliacao()->associate($this->motivo);
        $matricula->motivo_filiacao_outros = $this->motivoOutros;
        $matricula->data_filiacao = $this->data;
        $this->servidor->matriculas()->save($matricula);

        event(new ServidorAfiliado($this->servidor, $matricula));

        return $matricula;
    }

    private function valida()
    {
        if ($this->servidor->eAssociado()) {
            throw new ValidationException('Servidor já está filiado ao sindicato');
        }
    }
}
