<?php

namespace App\Providers;

use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;
use App\Events\ServidorAfiliado;
use App\Events\ServidorDesfiliadoDefinitivamente;
use App\Events\ServidorDesfiliadoTemporariamente;
use App\Events\ServidorReligado;
use App\Events\ServidorReligadoExtraordinariamente;
use App\Listeners\IncluiMovimentacaoServidorAfiliado;
use App\Listeners\IncluiMovimentacaoServidorDesfiliado;
use App\Listeners\IncluiMovimentacaoServidorReligado;
use App\Listeners\IncluiMovimentacaoServidorReligadoExtraordinariamente;
use App\Listeners\RemoveConvenios;
use App\Listeners\RestauraConvenios;

class EventServiceProvider extends ServiceProvider
{
    /**
     * The event listener mappings for the application.
     *
     * @var array
     */
    protected $listen = [
        ServidorAfiliado::class => [
            IncluiMovimentacaoServidorAfiliado::class,
        ],
        ServidorReligado::class => [
            IncluiMovimentacaoServidorReligado::class,
        ],
        ServidorDesfiliadoDefinitivamente::class => [
            IncluiMovimentacaoServidorDesfiliado::class,
            RemoveConvenios::class
        ],
        ServidorDesfiliadoTemporariamente::class => [
            IncluiMovimentacaoServidorDesfiliado::class,
        ],
        ServidorReligadoExtraordinariamente::class => [
            RestauraConvenios::class,
            IncluiMovimentacaoServidorReligadoExtraordinariamente::class,
        ],
    ];

    /**
     * Register any events for your application.
     *
     * @return void
     */
    public function boot()
    {
        parent::boot();
    }
}
