<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;

class MailResetPasswordNotification extends Notification
{
    use Queueable;

    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct($token)
    {
        $this->token = $token;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        $link = route("password.reset", ['token' => $this->token]);

        return (new MailMessage)
            ->from(env('MAIL_FROM_ADDRESS'))
            ->subject('Redefina sua senha')
            ->greeting('Olá!')
            ->line("Você está recebendo esse e-mail porque esqueceu sua senha. Clique no botão abaixo para redefinir sua senha:")
            ->action('Redefinir senha', $link)
            ->salutation('Atenciosamente,')
            ->line('Este link irá expirar em uma hora.');
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            //
        ];
    }
}
