<?php

namespace App\Models;

use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;
use Spatie\Permission\Models\Role as ModelsRole;

class Role extends ModelsRole implements AuditableContract
{
    use Auditable;

    protected $unassinableRoles = ['superuser'];

    public function scopeAssignable()
    {
        return self::whereNotIn('name', $this->unassinableRoles);
    }
}
