<?php

namespace App\Models;

use App\Enums\ResultadoProcessoJuridicoEnum;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

class ProcessoJuridico extends Model
{
    protected $table = 'processos_juridicos';
    protected $guarded = ['id', 'created_at', 'updated_at'];
    
    public function tipoAcao()
    {
        return $this->belongsTo(TipoAcaoProcesso::class);
    }

    public function competencia()
    {
        return $this->belongsTo(CompetenciaProcesso::class);
    }

    public function agendavel()
    {
        return $this->morphTo();
    }

    public function anexos()
    {
        return $this->hasMany(AnexoProcessoJuridico::class);
    }

    public function atendimentos()
    {
        return $this->hasMany(AtendimentoJuridico::class);
    }

    public function getResultadoAttribute()
    {
        if (!$this->attributes['resultado']) {
            return null;
        }

        return ResultadoProcessoJuridicoEnum::make($this->attributes['resultado']);
    }

    public function getDataPagamentoAttribute()
    {
        if ($data = $this->attributes['data_pagamento']) {
            return Carbon::create($data);
        }
    }

    public function setDataPagamentoAttribute($data)
    {
        if ($data) {
            $this->attributes['data_pagamento'] = Carbon::createFromFormat('d/m/Y', $data);
        }
    }

    public function numeroCompleto()
    {
        return "{$this->attributes['numero']}/{$this->attributes['vara']}";
    }
}
