<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class PlanoConta extends Model implements AuditableContract
{
    use Auditable;

    protected $table = 'planos_contas';
    protected $fillable = ['nome'];

    public function classificacoes()
    {
        return $this->hasMany(ClassificacaoConta::class, 'plano_contas_id');
    }

    public static function search($busca = '')
    {
        $result = self::query();

        if ($busca) {
            return $result->where(function ($query) use ($busca) {
                $query->where('nome', 'ilike', "%{$busca}%")
                       ->orderBy('nome', 'asc');
            });
        }

        return $result
            ->orderBy('nome', 'asc');
    }
}
