<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class PerguntaAnamnese extends Model implements AuditableContract
{
    use SoftDeletes, Auditable;

    protected $table = 'perguntas_anamnese';
    protected $fillable = ['descricao'];

    public function resposta()
    {
        return $this->hasOne(RespostaAnamnese::class, 'pergunta_anamnese_id');
    }

    public function scopeBuscaPorTermo($query, $termo)
    {
        if ($termo) {
            $query->where('descricao', 'ilike', "%{$termo}%");
        }

        return $query;
    }
}
