<?php

namespace App\Models;

use App\Enums\MotivoDesfiliacaoDefinitivaEnum;
use App\Enums\MotivoDesfiliacaoTemporariaEnum;
use App\Enums\TipoDesligamentoSindicatoEnum;
use App\Models\Servidor;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

class Matricula extends Model
{
    protected $fillable = ['data_filiacao', 'motivo_filiacao'];
    protected $dates = ['data_filiacao', 'data_desligamento', 'data_publicacao_portaria'];

    public function servidor()
    {
        return $this->belongsTo(Servidor::class, 'servidor_id');
    }

    public function motivoFiliacao()
    {
        return $this->belongsTo(MotivoFiliacao::class, 'motivo_filiacao_id');
    }

    public function scopeAtiva($query)
    {
        return $query->whereNull('data_desligamento');
    }

    public function scopeDesligadaTemporariamente($query)
    {
        return $query->where('tipo_desligamento', TipoDesligamentoSindicatoEnum::temporario()->getIndex());
    }

    public function scopeDesligadaDefinitivamente($query)
    {
        return $query->where('tipo_desligamento', TipoDesligamentoSindicatoEnum::definitivo()->getIndex());
    }

    public function setTipoDesligamentoAttribute(TipoDesligamentoSindicatoEnum $tipo = null)
    {
        if ($tipo === null) {
            $this->attributes['tipo_desligamento'] = null;
        } else {
            $this->attributes['tipo_desligamento'] = $tipo->getIndex();
        }
    }

    public function getTipoDesligamentoAttribute()
    {
        if ($this->attributes['tipo_desligamento']) {
            return TipoDesligamentoSindicatoEnum::make((int) $this->attributes['tipo_desligamento']);
        } else {
            return null;
        }
    }

    public function getMotivoDesligamentoAttribute()
    {
        if ($this->tipo_desligamento->isDefinitivo()) {
            return MotivoDesfiliacaoDefinitivaEnum::make((int) $this->attributes['motivo_desligamento']);
        } else {
            return MotivoDesfiliacaoTemporariaEnum::make((int) $this->attributes['motivo_desligamento']);
        }
    }

    public function setDataPublicacaoPortariaAttribute($data = null)
    {
        if ($data === null) {
            $this->attributes['data_publicacao_portaria'] = null;
        } else if ($data instanceof \DateTime) {
            $this->attributes['data_publicacao_portaria'] = $data;
        } else {
            $this->attributes['data_publicacao_portaria'] = Carbon::createFromFormat('d/m/Y', $data);
        }
    }

    public function scopeUltima($query)
    {
        return $query->whereRaw('id = (select max(id) from matriculas where servidor_id = servidores.id)');
    }
}
