<?php

namespace App\Models;

use App\Exceptions\ValidationException;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

class HorarioTrabalho extends Model
{
    protected $table = 'horarios_trabalho';
    protected $guarded = ['id', 'created_at', 'updated_at'];

    public function trabalhavel()
    {
        return $this->morphTo();
    }

    public function eValido()
    {
        if ($this->inicio && ! $this->fim) {
            throw new ValidationException("Quando o início é preenchido, o fim também deve ser preenchido");
        }

        if ($this->inicio->greaterThanOrEqualTo($this->fim)) {
            throw new ValidationException("Início do turno deve ser anterior ao fim");
        }
    }

    public function getInicioAttribute()
    {
        if (isset($this->attributes['inicio'])) {
            return Carbon::createFromFormat('H:i:s', $this->attributes['inicio']);
        }

        return null;
    }

    public function setInicioAttribute($inicio)
    {
        if (! $inicio) {
            return;
        }

        $this->attributes['inicio'] = Carbon::createFromFormat('H:i', $inicio)->format('H:i:s');
    }

    public function getFimAttribute()
    {
        if (isset($this->attributes['fim'])) {
            return Carbon::createFromFormat('H:i:s', $this->attributes['fim']);
        }

        return null;
    }

    public function setFimAttribute($fim)
    {
        if (! $fim) {
            return;
        }

        $this->attributes['fim'] = Carbon::createFromFormat('H:i', $fim)->format('H:i:s');
    }
}
