<?php

namespace App\Models;

use App\Traits\Contatavel;
use App\Traits\TemEndereco;
use Illuminate\Database\Eloquent\Model;

class Herdeiro extends Model
{
    use Contatavel;
    
    protected $fillable = ['nome'];

    public function servidor()
    {
        return $this->hasOne(Servidor::class);
    }

    public function endereco()
    {
        return $this->morphOne(Endereco::class, 'enderecavel')->withDefault();
    }
}
