<?php

namespace App\Models;

use App\Enums\GrauParentescoEnum;
use App\Enums\SexoEnum;
use App\Traits\Atendivel;
use App\Traits\Conveniavel;
use Carbon\Carbon;

class Dependente extends Pessoa
{
    use Atendivel;
    use Conveniavel;

    protected $guarded = ['id', 'grau_parentesco', 'sexo', 'created_at', 'updated_at'];
    protected $casts = [
        'ativo' => 'boolean',
        'falecido' => 'boolean',
        'deficiente' => 'boolean'
    ];

    public function tipo()
    {
        return 'dependente';
    }

    public function maiorDeIdade()
    {
        return $this->data_nascimento->diffInYears() >= 18;
    }

    public function dependivel()
    {
        return $this->morphTo();
    }

    public function setGrauParentescoAttribute(GrauParentescoEnum $grau)
    {
        $this->attributes['grau_parentesco'] = $grau->getIndex();
    }

    public function getGrauParentescoAttribute()
    {
        return GrauParentescoEnum::make($this->attributes['grau_parentesco']);
    }

    public function setSexoAttribute(SexoEnum $sexo)
    {
        $this->attributes['sexo'] = $sexo->getIndex();
    }

    public function getSexoAttribute()
    {
        return SexoEnum::make($this->attributes['sexo']);
    }

    public function setDataNascimentoAttribute($data)
    {
        $this->attributes['data_nascimento'] = Carbon::createFromFormat('d/m/Y', $data);
    }

    public function getDataNascimentoAttribute()
    {
        if ($this->attributes['data_nascimento'] instanceof Carbon) {
            return $this->attributes['data_nascimento'];
        }

        return Carbon::create($this->attributes['data_nascimento']);
    }

    public function setDataAdmissaoAttribute($data)
    {
        $this->attributes['data_admissao'] = Carbon::createFromFormat('d/m/Y', $data);
    }

    public function getDataAdmissaoAttribute()
    {
        return Carbon::create($this->attributes['data_admissao']);
    }

    public function scopeBuscaPorTermo($query, $termo)
    {
        $query->where('nome', 'ilike', "%{$termo}%");

        return $query->orderBy('nome');
    }

    public function scopeBusca($query, $busca)
    {
        return $query->where(function ($query) use ($busca) {
            $query->where('nome', 'ilike', "%{$busca}%");
        })->orderBy('nome');
    }

    public function routeNotificationForTwilio($notification)
    {
        if ($this->celularMalaDireta()) {
            return $this->celularMalaDireta()->getNumero();
        }

        return null;
    }
}
