<?php

namespace App\Models;

use App\Enums\MotivoExclusaoConvenioEnum;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ConvenioPessoa extends Model
{
    use SoftDeletes;

    protected $table = 'convenios_pessoas';
    protected $fillable = ['convenio_id'];
    protected $with = ['convenio'];

    public function conveniavel()
    {
        return $this->morphTo();
    }

    public function convenio()
    {
        return $this->belongsTo(Convenio::class, 'convenio_id');
    }

    public function scopeTemOsanOuSeguro($query)
    {
        return $query->whereHas('convenio', function ($query) {
            $query->osan();
        })->orWhereHas('convenio', function ($query) {
            $query->seguro();
        });
    }

    public function scopeOsan($query)
    {
        return $query->whereHas('convenio', function ($query) {
            $query->osan();
        });
    }

    public function scopeSeguro($query)
    {
        return $query->whereHas('convenio', function ($query) {
            $query->seguro();
        });
    }

    public function scopeMotivoExclusaoDesfiliacao($query)
    {
        return $query->where('motivo_exclusao', MotivoExclusaoConvenioEnum::desfiliacaoDefinitiva()->getIndex());
    }

    public function setMotivoExclusaoAttribute(MotivoExclusaoConvenioEnum $motivo = null)
    {
        if ($motivo) {
            $this->attributes['motivo_exclusao'] = $motivo->getIndex();
        } else {
            $this->attributes['motivo_exclusao'] = null;
        }
    }

    public function getMotivoExclusaoAttribute()
    {
        if ($this->attributes['motivo_exclusao']) {
            return MotivoExclusaoConvenioEnum::make($this->attributes['motivo_exclusao']);
        }

        return null;
    }
}
