<?php

namespace App\Models;

use App\Enums\TipoContatoEnum;
use Illuminate\Database\Eloquent\Model;

class Contato extends Model
{
    protected $guarded = ['id', 'created_at', 'updated_at'];
    
    public function contatavel()
    {
        return $this->morphTo();
    }

    public function scopeTelefones($query)
    {
        return $query->where('tipo', TipoContatoEnum::telefoneCelular()->getIndex())
                     ->orWhere('tipo', TipoContatoEnum::telefoneFixo()->getIndex());
    }
    
    public function scopeTelefonesCelulares($query)
    {
        return $query->where('tipo', TipoContatoEnum::telefoneCelular()->getIndex());
    }

    public function scopeTelefonesFixos($query)
    {
        return $query->where('tipo', TipoContatoEnum::telefoneFixo()->getIndex());
    }

    public function scopeEmails($query)
    {
        return $query->where('tipo', TipoContatoEnum::email()->getIndex());
    }

    public function scopeAceitaMalaDireta($query)
    {
        return $query->where('aceita_mala_direta', true);
    }

    public function scopeCelularMalaDireta($query)
    {
        return $query->telefonesCelulares()->aceitaMalaDireta();
    }

    public function eTelefoneFixo()
    {
        return $this->tipo == TipoContatoEnum::telefoneFixo()->getIndex();
    }

    public function eTelefoneCelular()
    {
        return $this->tipo == TipoContatoEnum::telefoneCelular()->getIndex();
    }

    public function eTelefone()
    {
        return $this->tipo == TipoContatoEnum::telefoneCelular()->getIndex() ||
               $this->tipo == TipoContatoEnum::telefoneFixo()->getIndex();
    }

    public function getNumero()
    {
        if ($this->eTelefone()) {
            return '+55' . str_replace(['(', ')', '-', ' '], '', $this->valor);
        }
    }

    public function getNumeroFormatado()
    {
        if ($this->eTelefone()) {
            return $this->valor;
        }
    }
}
