<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class AtendimentoJuridico extends Model
{
    protected $table = 'atendimentos_juridicos';
    protected $fillable = ['anotacoes'];

    public function agendamento()
    {
        return $this->belongsTo(AgendamentoAtendimento::class, 'agendamento_atendimento_id');
    }

    public function processoJuridico()
    {
        return $this->belongsTo(ProcessoJuridico::class, 'processo_juridico_id');
    }

    public function scopeBuscaPorTermo($query, $termo)
    {
        return $query->when($termo, function ($query) use ($termo) {
            $query->whereHas('agendamento', function ($query) use ($termo) {
                return $query->buscaPorTermo($termo);
            });
        });
    }
}
