<?php

namespace App\Listeners;

use App\Enums\EventoMovimentacaoServidorEnum;
use App\Models\MovimentacaoServidor;
use Illuminate\Support\Facades\Auth;

class IncluiMovimentacaoServidorDesfiliado
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  object  $event
     * @return void
     */
    public function handle($event)
    {
        $servidor = $event->servidor;
        $matricula = $event->matricula;

        $movimentacao = new MovimentacaoServidor();

        $movimentacao->descricao = 'Servidor desfiliado';
        $movimentacao->evento = EventoMovimentacaoServidorEnum::desfiliacao()->getIndex();

        $movimentacao->servidor()->associate($servidor);
        $movimentacao->user()->associate(Auth::user());
        $movimentacao->payload = [
            'data_desligamento' => $matricula->data_desligamento,
            'motivo_desligamento' => $matricula->motivo_desligamento,
            'tipo_desligamento' => $matricula->tipo_desligamento,
        ];
        $movimentacao->save();
    }
}
