<?php

namespace App\Listeners;

use App\Enums\EventoMovimentacaoServidorEnum;
use App\Events\ServidorAfiliado;
use App\Models\MovimentacaoServidor;
use Illuminate\Support\Facades\Auth;

class IncluiMovimentacaoServidorAfiliado
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  object  $event
     * @return void
     */
    public function handle(ServidorAfiliado $event)
    {
        $servidor = $event->servidor;
        $matricula = $event->matricula;

        $movimentacao = new MovimentacaoServidor();

        $movimentacao->descricao = 'Servidor afiliado';
        $movimentacao->evento = EventoMovimentacaoServidorEnum::filiacao()->getIndex();

        $movimentacao->servidor()->associate($servidor);
        $movimentacao->user()->associate(Auth::user());
        $movimentacao->payload = [
            'data_filiacao' => $matricula->data_filiacao,
            'motivo_filiacao' => $matricula->motivoFiliacao->descricao,
            'motivo_outros' => $matricula->motivo_filiacao_outros,
        ];
        $movimentacao->save();
    }
}
