<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ProcessoJuridicoStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    public function prepareForValidation()
    {
        if ($this->valor_pago) {
            $valorPago = floatval(str_replace(',', '.', str_replace('.', '', $this->valor_pago)));
        } else {
            $valorPago = null;
        }
        $this->merge([
      'valor_pago' => $valorPago,
    ]);
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
      'numero'            => 'required|max:30',
      'vara'              => 'nullable|max:10',
      'competencia_id'    => 'required|numeric',
      'tipo_acao_id'      => 'required|numeric',
      'resultado'         => 'nullable|numeric',
      'extinto'           => 'required|boolean',
      'pago'              => 'required|boolean',
      'data_pagamento'    => 'nullable|required_if:pago,1|date_format:d/m/Y|before_or_equal:' . today(),
      'valor_pago'        => 'nullable|required_if:pago,1|numeric',

    ];
    }

    public function withValidator($validator)
    {
        $validator->after(function ($validator) {
            if ($this->data_pagamento && !$this->valor_pago) {
                $validator->errors()->add('valor_pago', 'O campo Valor pago deve ser preenchido junto a Data de pagamento');
            }

            if ($this->valor_pago && !$this->data_pagamento) {
                $validator->errors()->add('data_pagamento', 'O campo Data de pagamento deve ser preenchido junto o Valor pago');
            }

            if ($this->data_pagamento && !$this->pago) {
                $validator->errors()->add('pago', 'Informe se o processo foi pago');
            }

            if ($this->valor_pago && !$this->pago) {
                $validator->errors()->add('valor_pago', 'Informe se o processo foi pago');
            }
        });
    }

    public function attributes()
    {
        return [
      'competencia_id' => 'competência',
      'tipo_acao_id' => 'tipo',
      'numero' => 'número',
    ];
    }

    public function messages()
    {
        return [
      'data_pagamento.required_if' => 'O campo Data de pagamento é obrigatório quando processo foi pago',
      'valor_pago.required_if' => 'O campo Valor pago é obrigatório quando processo foi pago',
      'data_pagamento.before_or_equal' => 'O campo Data de pagamento deve ter uma data anterior ou igual à atual',
    ];
    }
}
