<?php

namespace App\Http\Requests;

use App\Rules\CNPJRule;
use App\Rules\CPFRule;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class PrestadorServicoStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    protected function prepareForValidation(): void
    {
        $this->merge([
            'cpf' => str_replace(['.', '-'], '', $this->cpf)
        ]);
        $this->merge([
            'rg' => str_replace(['.', '-'], '', $this->rg)
        ]);
        $this->merge([
            'cnpj' => str_replace(['.', '-', '/'], '', $this->cnpj)
        ]);
        $this->merge([
            'cep' => str_replace('-', '', $this->cep)
        ]);
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'nome' => 'required|max:150|unique:prestadores_servicos',
            'funcao' => 'nullable|max:50',
            'tipo' => 'required|max:50',
            'especialidade' => 'required_if:tipo,1', // Dentista
            'rg' => 'nullable|max:10',
            'cpf' => ['nullable', 'unique:prestadores_servicos', new CPFRule()],
            'cnpj' => ['nullable', 'unique:prestadores_servicos', new CNPJRule()],
            'sexo' => 'nullable|numeric',
            'observacoes' => 'nullable',
            'cep' => 'nullable|numeric',
            'logradouro' => 'nullable|required_with:cep|max:150',
            'bairro' => 'nullable|required_with:cep|max:50',
            'cidade' => 'nullable|required_with:cep|max:100',
            'numero' => 'nullable|numeric|required_with:cep',
            'estado' => 'nullable|required_with:cep|max:2',
            'observacoes_endereco' => 'nullable|max:100',
        ];
    }

    public function messages()
    {
        return [
            'especialidade.required_if' => 'O campo especialidade é obrigatório quando o tipo for Dentista'
        ];
    }
}
