<?php

namespace App\Http\Requests;

use App\Enums\NivelSalarialEnum;
use App\Models\MensalidadeNivel;
use Illuminate\Foundation\Http\FormRequest;

class MensalidadeNivelDeleteRequest extends FormRequest
{
    protected function prepareForValidation()
    {
        $mensalidadeAnterior = MensalidadeNivel::anterior($this->mensalidade->nivelSalarial);

        $this->merge([
            'nivelSalarial' => $this->mensalidade->nivel,
            'mensalidadeAnterior' => $mensalidadeAnterior,
        ]);
    }

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    public function withValidator($validator)
    {
        $validator->after(function ($validator) {
            if ($this->unicaMensalidadeNivel()) {
                $validator->errors()->add('inicio_vigencia', 'Deve haver uma mensalidade vigente para o nível');
            }
        });
    }

    private function unicaMensalidadeNivel()
    {
        if ($this->mensalidadeAnterior == null) {
            return true;
        }
        
        return false;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [

        ];
    }
}
