<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class GoogleCalendarEventUpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'titulo' => 'required|max:100',
            'descricao' => 'nullable|max:255',
            'local' => 'nullable|max:50',
            'data_inicio_fim' => 'required|regex:/^\d{2}\/\d{2}\/\d{4} \d{2}\:\d{2} - \d{2}\/\d{2}\/\d{4} \d{2}\:\d{2}$/'
        ];
    }
}
