<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class DependenteUpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'nome' => 'required|max:100',
            'data_nascimento' => 'required|date_format:d/m/Y',
            'data_admissao' => 'required|date_format:d/m/Y',
            'grau_parentesco' => 'required|numeric',
            'sexo' => 'required|numeric',
            'convenio' => 'nullable|numeric',
            'ativo' => 'required|boolean',
            'especial' => 'required|boolean',
            'observacoes' => 'nullable',
        ];
    }
}
