<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ContaReceberUpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'descricao' => 'required|max:255',
            'numero_documento' => 'required_if:forma_recebimento,2|max:255',
            'status' => 'required|numeric',
            'valor_pago' => 'nullable|required',
            'forma_recebimento' => 'required',
            'data_pagamento' => 'required',
        ];
    }

    public function attributes()
    {
        return [
            'descricao' => 'descrição',
            'forma_recebimento' => 'forma de recebimento',
            'numero_documento' => 'número cheque',
            'data_pagamento' => 'data',
            'valor_pago' => 'valor',
        ];
    }

    public function messages()
    {
        return [
            'numero_documento.required_if' => 'O campo número cheque é obrigatório quando a forma de recebimento for Cheque'
        ];
    }
}
