<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ContaPagarStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'descricao' => 'required|max:255',
            'numero_documento' => 'nullable',
            'nota_fiscal' => 'nullable|max:100',
            'valor' => 'required',
            'status' => 'required|numeric',
            'tipo_despesa' => 'required|numeric',
            'responsavel_despesa' => 'nullable|required_if:tipo_despesa,2', // Despesa extra
            'recorrencia' => 'nullable',
            'vencimento' => 'required|date_format:d/m/Y',
            'status' => 'required|numeric',
            'valor_pago' => 'nullable|required_if:status,2', // Pago
            'forma_pagamento' => 'nullable|required_if:status,2', // Pago
            'data_pagamento' => 'nullable|required_if:status,2', // Pago
            'caminho_documento' => 'nullable|file',
            'plano_contas_id' => 'required|numeric',
            'classificacao_conta_id' => 'required|numeric',
        ];
    }

    public function attributes()
    {
        return [
            'descricao' => 'descrição',
            'responsavel_despesa' => 'responsável despesa',
            'forma_pagamento' => 'forma de pagamento',
            'caminho_documento' => 'documento',
            'numero_documento' => 'número documento',
            'vencimento' => 'data',
        ];
    }

    public function messages()
    {
        return [
            'responsavel_despesa.required_if' => 'O campo Responsável despesa é obrigatório quando o tipo de despesa for Extra',
            'data_pagamento.required_if' => 'O campo Data de pagamento é obrigatório quando o status for Pago',
            'valor_pago.required_if' => 'O campo Valor pago é obrigatório quando o status for Pago',
            'forma_pagamento.required_if' => 'O campo Forma de pagamento é obrigatório quando o status for Pago',
        ];
    }
}
