<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class AgendamentoAtendimentoUpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    protected function prepareForValidation(): void
    {
        $this->merge([
            'data' => "$this->data $this->hora_inicio",
            'hora_inicio' => "$this->data $this->hora_inicio",
            'hora_fim' => "$this->data $this->hora_fim",
        ]);
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'data' => 'required|date_format:d/m/Y G:i|after_or_equal:now',
            'hora_inicio' => 'required|date_format:d/m/Y G:i',
            'hora_fim' => 'required|date_format:d/m/Y G:i|after:hora_inicio',
        ];
    }

    public function messages()
    {
        return [
            'data.after_or_equal' => 'Agendamento deve ser para uma data/hora igual ou posterior à atual',
            'hora_fim.after' => 'Hora fim deve ser posterior à hora de início',
        ];
    }
}
