<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class AfiliaServidorRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [];
    }
    public function withValidator($validator)
    {
        $validator->after(function ($validator) {
            if ($this->servidor->desfiliadoDefinitivamente()) {
                if (!$this->data_filiacao) {
                    $validator->errors()->add('data_filiacao', 'O campo Data de admissão é obrigatório');
                }

                if (!$this->motivo_filiacao) {
                    $validator->errors()->add('motivo_filiacao', 'O campo Motivo é obrigatório');
                }

                if ($this->motivo_filiacao == 5 && !$this->motivo_filiacao_outros) {
                    $validator->errors()->add('motivo_filiacao_outros', 'O campo Detalhe do motivo é obrigatório quando o motivo for "Outros"');
                }
            }
        });
    }
}
