<?php

namespace App\Http\Controllers\Admin\Servidor;

use App\Enums\GrauParentescoEnum;
use App\Enums\SexoEnum;
use App\Http\Controllers\Controller;
use App\Http\Requests\DependenteStoreRequest;
use App\Http\Requests\DependenteUpdateRequest;
use App\Models\Convenio;
use App\Models\Dependente;
use App\Models\Servidor;

class DependenteServidorController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Servidor $servidor)
    {
        $dependentes = $servidor->dependentes()->orderBy('nome')->get();

        return view('admin.dependentes.index', [
            'dependentes' => $dependentes,
            'dependido' => 'Servidor',
            'routes' => $this->routes($servidor),
        ]);
    }

    private function routes($servidor, $dependente = null)
    {
        return [
            'dependido' => [
                'key' => 'servidor',
                'index' => ['route' => 'admin.servidores.index'],
                'edit' =>  ['route' => 'admin.servidores.edit', 'params' => ['servidor' => $servidor]],
                'nome' => $servidor->nome,
            ],
            'dependente' => [
                'index'  => ['route' => 'admin.servidores.dependentes.index', 'params' => ['servidor' => $servidor]],
                'create' => ['route' => 'admin.servidores.dependentes.create', 'params' => ['servidor' => $servidor]],
                'edit'   => ['route' => 'admin.servidores.dependentes.edit', 'params' => ['servidor' => $servidor]],
                'store'  => ['route' => 'admin.servidores.dependentes.store', 'params' => ['servidor' => $servidor]],
                'update'  => ['route' => 'admin.servidores.dependentes.update', 'params' => ['servidor' => $servidor, 'dependente' => $dependente]],
                'destroy'  => ['route' => 'admin.servidores.dependentes.destroy', 'params' => ['servidor' => $servidor]],
            ],
            'convenio' => [
                'index'  => ['route' => 'admin.servidores.dependentes.convenios.index', 'params' => ['servidor' => $servidor, 'dependente' => $dependente]],
                'create' => ['route' => 'admin.servidores.dependentes.convenios.create', 'params' => ['servidor' => $servidor, 'dependente' => $dependente]],
                'edit'   => ['route' => 'admin.servidores.dependentes.convenios.edit', 'params' => ['servidor' => $servidor, 'dependente' => $dependente]],
                'store'  => ['route' => 'admin.servidores.dependentes.convenios.store', 'params' => ['servidor' => $servidor, 'dependente' => $dependente]],
                'update'  => ['route' => 'admin.servidores.dependentes.convenios.update', 'params' => ['servidor' => $servidor, 'dependente' => $dependente, 'dependente' => $dependente]],
                'destroy'  => ['route' => 'admin.servidores.dependentes.convenios.destroy', 'params' => ['servidor' => $servidor, 'dependente' => $dependente]],
            ],
        ];
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Servidor $servidor)
    {
        $graus = GrauParentescoEnum::getAll();
        $sexos = SexoEnum::getAll();
        $convenios = Convenio::all();
        return view('admin.dependentes.create', [
            'graus' => $graus,
            'sexos' => $sexos,
            'convenios' => $convenios,
            'dependido' => 'Servidor',
            'routes' => $this->routes($servidor)
        ]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(DependenteStoreRequest $request, Servidor $servidor)
    {
        $dependente = new Dependente($request->all());
        $dependente->grau_parentesco = GrauParentescoEnum::make((int) $request->grau_parentesco);
        $dependente->sexo = SexoEnum::make((int) $request->sexo);
        $servidor->dependentes()->save($dependente);

        return redirect()
            ->route('admin.servidores.dependentes.index', ['servidor' => $servidor])
            ->with('status', 'Dependente incluído com sucesso!');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Dependente  $dependente
     * @return \Illuminate\Http\Response
     */
    public function edit(Servidor $servidor, Dependente $dependente)
    {
        $graus = GrauParentescoEnum::getAll();
        $sexos = SexoEnum::getAll();
        $convenios = Convenio::all();
        return view('admin.dependentes.edit', [
            'graus' => $graus,
            'sexos' => $sexos,
            'convenios' => $convenios,
            'dependente' => $dependente,
            'dependido' => 'Servidor',
            'routes' => $this->routes($servidor, $dependente)
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Dependente  $dependente
     * @return \Illuminate\Http\Response
     */
    public function update(DependenteUpdateRequest $request, Servidor $servidor, Dependente $dependente)
    {
        $dependente->fill($request->all());
        $dependente->grau_parentesco = GrauParentescoEnum::make((int) $request->grau_parentesco);
        $dependente->sexo = SexoEnum::make((int) $request->sexo);
        $dependente->save();

        return redirect()
            ->route('admin.servidores.dependentes.index', ['servidor' => $servidor])
            ->with('status', 'Dependente editado com sucesso!');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Dependente  $dependente
     * @return \Illuminate\Http\Response
     */
    public function destroy(Servidor $servidor, Dependente $dependente)
    {
        $dependente->delete();

        return redirect()
            ->route('admin.servidores.dependentes.index', ['servidor' => $servidor])
            ->with('status', 'Dependente excluído com sucesso!');
    }
}
