<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\PerguntaAnamnese;
use Illuminate\Http\Request;

class PerguntaAnamneseController extends Controller
{
    public function __construct()
    {
        $this->middleware(['auth', 'role:admin']);
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $busca = $request->busca;
        $inativos = $request->inativos;
        $perguntas = PerguntaAnamnese::buscaPorTermo($busca);
        
        if ($inativos) {
            $perguntas->withTrashed();
        }


        return view('admin.perguntas-anamnese.index', [
                'perguntas' => $perguntas->paginate(),
                'busca' => $busca,
                'inativos' => $inativos
        ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.perguntas-anamnese.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'descricao' => 'required|max:150'
        ]);

        $pergunta = new PerguntaAnamnese($request->all());
        $pergunta->save();

        return redirect()->route('admin.perguntas-anamnese.index')
                ->with('status', 'Pergunta incluída com sucesso!');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\PerguntaAnamnese  $pergunta
     * @return \Illuminate\Http\Response
     */
    public function edit(PerguntaAnamnese $pergunta)
    {
        return view('admin.perguntas-anamnese.edit', [
            'pergunta' => $pergunta
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\PerguntaAnamnese  $pergunta
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, PerguntaAnamnese $pergunta)
    {
        $this->validate($request, [
            'descricao' => 'required|max:150'
        ]);

        $pergunta->fill($request->all());
        $pergunta->save();

        return redirect()->route('admin.perguntas-anamnese.index')
            ->with('status', 'Pergunta alterada com sucesso!');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\PerguntaAnamnese  $pergunta
     * @return \Illuminate\Http\Response
     */
    public function destroy(PerguntaAnamnese $pergunta)
    {
        $pergunta->delete();

        return redirect()->route('admin.perguntas-anamnese.index')
        ->with('status', 'Pergunta excluída com sucesso!');
    }

    public function restore(PerguntaAnamnese $pergunta)
    {
        $pergunta->withTrashed()->restore();

        return redirect()
            ->back()
            ->with('status', 'Pergunta restaurada com sucesso!');
    }
}
