<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\MotivoFiliacao;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;

class MotivoFiliacaoController extends Controller
{
    public function __construct()
    {
        $this->middleware(['auth', 'role:admin']);
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $motivos = MotivoFiliacao::all();

        return view('admin.motivos-filiacao.index', ['motivos' => $motivos]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.motivos-filiacao.create');
    }

    public function store(Request $request)
    {
        $this->validate($request, [
            'descricao' => 'required|max:100|unique:motivos_filiacao,descricao',
        ]);

        $motivo = new MotivoFiliacao($request->all());
        $motivo->save();

        return redirect()
                ->route('admin.motivos-filiacao.index')
                ->with('status', 'Motivo incluído com sucesso!');
    }

    public function edit(MotivoFiliacao $motivo) {
        return view('admin.motivos-filiacao.edit', ['motivo' => $motivo]);
    }

    public function update(Request $request, MotivoFiliacao $motivo)
    {
        $this->validate($request, [
            'descricao' => ['required', 'max:100', Rule::unique('motivos_filiacao')->ignore($motivo)],
        ]);

        $motivo->fill($request->all());
        $motivo->save();

        return redirect()
            ->route('admin.motivos-filiacao.index')
            ->with('status', 'Motivo editado com sucesso!');
    }

    public function destroy(MotivoFiliacao $motivo)
    {
        $motivo->delete();

        return redirect()
            ->route('admin.motivos-filiacao.index')
            ->with('status', 'Motivo excluído com sucesso!');
    }
}
