<?php

namespace App\Http\Controllers\Admin;

use App\Enums\FiltroBuscaServidorEnum;
use App\Http\Controllers\Controller;
use App\Models\Servidor;
use Illuminate\Http\Request;

class GeracaoCarteirinhaController extends Controller
{
    public function index(Request $request)
    {
        $servidores = [];

        if ($request->has('filtro')) {
            $filtro = FiltroBuscaServidorEnum::make((int) $request->filtro);
        } else {
            $filtro = null;
        }

        if ($request->busca) {
            $servidores = Servidor::associado()
                ->with('registros')
                ->busca($filtro, $request->busca)
                ->get();
        }

        return view('admin.geracao-carteirinha.index', [
            'servidores' => $servidores,
            'busca' => $request->busca,
            'filtroSelecionado' => $filtro,
            'filtrosServidores' => FiltroBuscaServidorEnum::getAll(),
        ]);
    }

    public function gera(Request $request)
    {
        $this->validate($request, [
            'selecao' => 'required|in:selecionar,todos',
            'servidores' => 'nullable|array|required_if:selecao,selecionar',
            'via' => 'required',
        ]);

        $servidores = Servidor::associado()
            ->with('matriculas', 'registros.unidadeOrganizacional')
            ->comRegistroAtivo();

        if ($request->servidores) {
            $servidores->whereIn('id', $request->servidores);
        }

        return view('admin.geracao-carteirinha.geracao', [
            'servidores' => $servidores->get()
        ]);
    }
}
