<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\EspecialidadeConvenio;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;

class EspecialidadeConvenioController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $termo = $request->busca;
        $especialidades = EspecialidadeConvenio::buscaPorTermo($termo)
                            ->paginate();

        return view('admin.especialidades-convenios.index', [
            'especialidades' => $especialidades,
            'termo' => $termo
        ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.especialidades-convenios.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'nome' => 'required|max:50|unique:especialidades_convenios'
        ]);

        $especialidade = new EspecialidadeConvenio($request->all());
        $especialidade->save();

        return redirect()
            ->route('admin.especialidades-convenios.index')
            ->with('status', 'Especialidade incluída com sucesso!');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\EspecialidadeConvenio  $especialidade
     * @return \Illuminate\Http\Response
     */
    public function edit(EspecialidadeConvenio $especialidade)
    {
        return view('admin.especialidades-convenios.edit', ['especialidade' => $especialidade]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\EspecialidadeConvenio  $especialidade
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, EspecialidadeConvenio $especialidade)
    {
        $this->validate($request, [
            'nome' => ['required', 'max:50', Rule::unique('especialidades_convenios')->ignore($especialidade)]
        ]);

        $especialidade->fill($request->all());
        $especialidade->save();

        return redirect()
            ->route('admin.especialidades-convenios.index')
            ->with('status', 'Especialidade editada com sucesso!');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\EspecialidadeConvenio  $especialidade
     * @return \Illuminate\Http\Response
     */
    public function destroy(EspecialidadeConvenio $especialidade)
    {
        $especialidade->delete();

        return redirect()
            ->route('admin.especialidades-convenios.index')
            ->with('status', 'Especialidade excluída com sucesso!');
    }
}
