<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\CompetenciaProcesso;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;

class CompetenciaProcessoController extends Controller
{
    public function __construct()
    {
        $this->middleware(['auth', 'role:admin']);
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $competencias = CompetenciaProcesso::orderBy('descricao')->get();

        return view('admin.competencias-processos.index', ['competencias' => $competencias]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.competencias-processos.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'descricao' => 'required|max:50|unique:competencias_processos,descricao',
        ], [], ['descricao' => 'descrição']);

        $competencia = new CompetenciaProcesso($request->all());
        $competencia->save();

        return redirect()
                ->route('admin.competencias-processos.index')
                ->with('status', 'Competência incluída com sucesso!');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\CompetenciaProcesso  $competencia
     * @return \Illuminate\Http\Response
     */
    public function edit(CompetenciaProcesso $competencia)
    {
        return view('admin.competencias-processos.edit', ['competencia' => $competencia]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\CompetenciaProcesso  $competencia
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, CompetenciaProcesso $competencia)
    {
        $this->validate($request, [
            'descricao' => ['required', 'max:50', Rule::unique('competencias_processos')->ignore($competencia)],
        ], [], ['descricao' => 'descrição']);

        $competencia->fill($request->all());
        $competencia->save();

        return redirect()
            ->route('admin.competencias-processos.index')
            ->with('status', 'Competência editada com sucesso!');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\CompetenciaProcesso  $competencia
     * @return \Illuminate\Http\Response
     */
    public function destroy(CompetenciaProcesso $competencia)
    {
        $competencia->delete();

        return redirect()
            ->route('admin.competencias-processos.index')
            ->with('status', 'Competência excluída com sucesso!');
    }
}
