<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Dependente;
use Illuminate\Http\Request;

class BuscaDependenteController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $busca = $request->busca;
        $dependentes = Dependente::busca($busca)->paginate();
        return view('admin.dependentes.busca', [
            'dependentes' => $dependentes,
            'busca' => $busca,
        ]);
    }
}
