<?php

namespace App\Http\Controllers\Admin;

use App\Enums\TipoAgendamentoEnum;
use App\Http\Controllers\Controller;
use App\Models\AgendamentoAtendimento;
use App\Models\Dependente;
use App\Models\Funcionario;
use App\Models\PerguntaAnamnese;
use App\Models\RespostaAnamnese;
use App\Models\Servidor;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class AnamneseAtendimentoController extends Controller
{
    private function buscaPessoaPorTipoId($tipo, $id)
    {
        if ($tipo == 'funcionario') {
            $pessoa = Funcionario::findOrFail($id);
        }

        if ($tipo == 'associado') {
            $pessoa = Servidor::findOrFail($id);
        }

        if ($tipo == 'dependente') {
            $pessoa = Dependente::findOrFail($id);
        }

        return $pessoa;
    }
    
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function createEdit($pessoa, $tipo)
    {
        $perguntas = PerguntaAnamnese::all();
        $agendavel = $this->buscaPessoaPorTipoId($tipo, $pessoa);
        
        return view('admin.anamnese-atendimento.create-edit', [
            'pessoa' => $pessoa,
            'agendavel' => $agendavel,
            'tipo' => $tipo,
            'perguntas' => $perguntas,
            'respostas' => $agendavel->anamnese->respostas,
            'agendamento' => request()->agendamento,
        ]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $respostas = $request->input('respostas', []);
        $pessoa = $request->pessoa;
        $tipo = $request->tipo;
        $agendavel = $this->buscaPessoaPorTipoId($tipo, $pessoa);

        DB::beginTransaction();
        
        $agendavel->anamnese->save();

        foreach ($respostas as $idPergunta => $resposta) {
            $respostaAnamnese = RespostaAnamnese::firstOrCreate([
                'anamnese_id' => $agendavel->anamnese->id, 'pergunta_anamnese_id' => $idPergunta
            ]);
            $pergunta = PerguntaAnamnese::find($idPergunta);

            if (isset($resposta['resposta'])) {
                $respostaAnamnese->resposta = true;
                $respostaAnamnese->qual = $resposta['qual'];
            }
            
            $respostaAnamnese->pergunta()->associate($pergunta);
            $respostaAnamnese->anamnese()->associate($agendavel->anamnese);
            $respostaAnamnese->push();
        }

        DB::commit();

        return redirect()
                ->back()
                ->with('status', 'Anamnese salva com sucesso!');
    }

    public function impressao($pessoa, $tipo)
    {
        $agendavel = $this->buscaPessoaPorTipoId($tipo, $pessoa);
        $perguntas = PerguntaAnamnese::all();
        $respostas = $agendavel->anamnese->respostas;

        return view('admin.impressos.anamnese', [
            'pessoa' => $pessoa,
            'agendavel' => $agendavel,
            'perguntas' => $perguntas,
            'respostas' => $respostas,
        ]);
    }
}
