<?php

namespace App\Exceptions;

use App\Enums\TipoAgendamentoEnum;
use App\Models\PrestadorServico;

class TipoPrestadorErradoAtendimentoException extends ValidationException
{
    public function __construct(PrestadorServico $prestador, TipoAgendamentoEnum $tipo)
    {
        $this->message = "O prestador {$prestador->nome} não pode fazer atendimentos do tipo $tipo";
        $this->code = 0;
    }
}
