<?php

namespace App\Exceptions;

use App\Models\PrestadorServico;
use Carbon\Carbon;

class PrestadorSemEspecialidadeException extends ValidationException
{
    public function __construct(PrestadorServico $prestadorServico)
    {
        $this->message = "O prestador {$prestadorServico->nome} não possui uma especialidade definida";
        $this->code = 0;
    }
}
