<?php

namespace App\Exceptions;

use App\Enums\CategoriaConfiguracaoEnum;

class ConfiguracaoNaoEncontradaException extends \RuntimeException
{
    public function __construct(string $nome, CategoriaConfiguracaoEnum $categoria)
    {
        $message = "Configuração '{$nome}' não encontrada para categoria '{$categoria->getValue()}'";
        parent::__construct($message, 0);
    }
}
