<?php

namespace App\Events;

use App\Models\Matricula;
use App\Models\Servidor;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class ServidorDesfiliadoDefinitivamente
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public $servidor;
    public $matricula;
    
    /**
     * Create a new event instance.
     *
     * @return void
     */
    public function __construct(Servidor $servidor, Matricula $matricula)
    {
        $this->servidor = $servidor;
        $this->matricula = $matricula;

        info("Servidor {$servidor->nome} desfiliado definitivamente", [
            'servidor' => $servidor,
            'matricula' => $matricula
        ]);
    }

    /**
     * Get the channels the event should broadcast on.
     *
     * @return \Illuminate\Broadcasting\Channel|array
     */
    public function broadcastOn()
    {
        return new PrivateChannel('channel-name');
    }
}
