<?php

namespace App\Enums;

use Spatie\Enum\Enum;

/**
 * @method static self fundamentalIncompleto()
 * @method static self fundamentalCompleto()
 * @method static self superiorIncompleto()
 * @method static self superiorCompleto()
 * @method static self posGraduacaoIncompleto()
 * @method static self posGraduacaoCompleto()
 * @method static self mestradoIncompleto()
 * @method static self mestradoCompleto()
 * @method static self doutoradoIncompleto()
 * @method static self doutoradoCompleto()
 */
class NivelEnsinoEnum extends Enum
{
    const MAP_INDEX = [
        'fundamentalIncompleto' => 1,
        'fundamentalCompleto' => 2,
        'superiorIncompleto' => 3,
        'superiorCompleto' => 4,
        'posGraduacaoIncompleto' => 5,
        'posGraduacaoCompleto' => 6,
        'mestradoIncompleto' => 7,
        'mestradoCompleto' => 8,
        'doutoradoIncompleto' => 9,
        'doutoradoCompleto' => 10,
    ];
    const MAP_VALUE = [
        'fundamentalIncompleto' => 'FUNDAMENTAL INCOMPLETO',
        'fundamentalCompleto' => 'FUNDAMENTAL COMPLETO',
        'superiorIncompleto' => 'SUPERIOR INCOMPLETO',
        'superiorCompleto' => 'SUPERIOR COMPLETO',
        'posGraduacaoIncompleto' => 'PÓS GRADUAÇÃO INCOMPLETO',
        'posGraduacaoCompleto' => 'PÓS GRADUAÇÃO COMPLETO',
        'mestradoIncompleto' => 'MESTRADO INCOMPLETO',
        'mestradoCompleto' => 'MESTRADO COMPLETO',
        'doutoradoIncompleto' => 'DOUTORADO INCOMPLETO',
        'doutoradoCompleto' => 'DOUTORADO COMPLETO',
    ];
}
