<?php

namespace App\Enums;

use Spatie\Enum\Enum;

/**
 * @method static self ausente()
 * @method static self licencaMedica()
 * @method static self processoExoneracao()
 * @method static self regimePrisao()
 * @method static self semMargemDesconto()
 * @method static self licencaSemVencimentos()
 */
class MotivoDesfiliacaoTemporariaEnum extends Enum
{
    const MAP_INDEX = [
        'ausente' => 1,
        'licencaMedica' => 2,
        'processoExoneracao' => 3,
        'regimePrisao' => 4,
        'semMargemDesconto' => 5,
        'licencaSemVencimentos' => 6,
    ];

    const MAP_VALUE = [
        'ausente' => 'AUSENTE',
        'licencaMedica' => 'LICENÇA MÉDICA',
        'processoExoneracao' => 'PROCESSO DE EXONERAÇÃO',
        'regimePrisao' => 'REGIME DE PRISÃO',
        'semMargemDesconto' => 'SEM MARGEM PARA DESCONTO',
        'licencaSemVencimentos' => 'LICENÇA SEM VENCIMENTOS',
    ];
}
