<?php

namespace App\Enums;

use Spatie\Enum\Enum;

/**
 * @method static self voluntario()
 * @method static self falecido()
 * @method static self exoneracao()
 * @method static self demitido()
 * @method static self terminoContrato()
 */
class MotivoDesfiliacaoDefinitivaEnum extends Enum
{
    const MAP_INDEX = [
        'voluntario' => 1,
        'falecido' => 2,
        'exoneracao' => 3,
        'demitido' => 4,
        'terminoContrato' => 5,
    ];

    const MAP_VALUE = [
        'voluntario' => 'VOLUNTÁRIO (A)',
        'falecido' => 'FALECIDO (A)',
        'exoneracao' => 'EXONERAÇÃO',
        'demitido' => 'DEMITIDO (A)',
        'terminoContrato' => 'TÉRMINO CONTRATO',
    ];
}
