<?php

namespace App\Enums;

use Spatie\Enum\Enum;

/**
 * @method static self inclusao()
 * @method static self edicao()
 * @method static self exclusao()
 * @method static self restauracao()
 * @method static self filiacao()
 * @method static self desfiliacao()
 * @method static self religamento()
 * @method static self religamentoExtraordinario()
 */
class EventoMovimentacaoServidorEnum extends Enum
{
    const MAP_INDEX = [
        'inclusao' => 1,
        'edicao' => 2,
        'exclusao' => 3,
        'restauracao' => 4,
        'filiacao' => 5,
        'desfiliacao' => 6,
        'religamento' => 7,
        'religamentoExtraordinario' => 8,
    ];

    const MAP_VALUE = [
        'inclusao' => 'INCLUSÃO',
        'edicao' => 'EDIÇÃO',
        'exclusao' => 'EXCLUSÃO',
        'restauracao' => 'RESTAURAÇÃO',
        'filiacao' => 'FILIAÇÃO',
        'desfiliacao' => 'DESFILIAÇÃO',
        'religamento' => 'RELIGAMENTO',
        'religamentoExtraordinario' => 'RELIGAMENTO EXTRAORDINÁRIO',
    ];
}
