<?php

namespace App\Console\Commands;

use App\Models\MovimentacaoServidor;
use Illuminate\Console\Command;

class MigraEventoMovimentacaoCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'movimentacoes-servidores:migra-eventos';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Migra eventos de string para inteiro';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $this->info("Iniciando migração...");
        MovimentacaoServidor::where('evento', 'ilike', 'Inclusão')->update(['evento' => 1]);
        MovimentacaoServidor::where('evento', 'ilike', 'Edição')->update(['evento' => 2]);
        MovimentacaoServidor::where('evento', 'ilike', 'Exclusão')->update(['evento' => 3]);
        MovimentacaoServidor::where('evento', 'ilike', 'Restauração')->update(['evento' => 4]);
        MovimentacaoServidor::where('evento', 'ilike', 'Filiação')->update(['evento' => 5]);
        MovimentacaoServidor::where('evento', 'ilike', 'Associação')->update(['evento' => 5]);
        MovimentacaoServidor::where('evento', 'ilike', 'Desfiliação')->update(['evento' => 6]);
        MovimentacaoServidor::where('evento', 'ilike', 'Desassociação')->update(['evento' => 6]);
        MovimentacaoServidor::where('evento', 'ilike', 'religamentoExtraordinario')->update(['evento' => 7]);
        $this->info("Migração finalizada");
    }
}
